///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabClientDBSDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND SQLServer_hWnd;
    static HWND SQLDriver_hWnd;
    static HWND SQLUserName_hWnd;
    static HWND SQLPassword_hWnd;
    static HWND TempDir_hWnd;

    if(xMessage == WM_INITDIALOG)
    {
        SQLServer_hWnd   = GetDlgItem(xHandle, IDC_SQLSERVER);
        SQLDriver_hWnd   = GetDlgItem(xHandle, IDC_SQLDRIVER);
        SQLUserName_hWnd = GetDlgItem(xHandle, IDC_SQLUSERNAME);
        SQLPassword_hWnd = GetDlgItem(xHandle, IDC_SQLPASSWORD);
        TempDir_hWnd     = GetDlgItem(xHandle, IDC_TEMPDIR);

        Set_Text(SQLServer_hWnd, gsSQLCustServer);
        Set_Text(SQLDriver_hWnd, gsSQLCustDriver);
        Set_Text(SQLUserName_hWnd, gsSQLCustUserID);
        Set_Text(SQLPassword_hWnd, gsSQLCustPassword);
        Set_Text(TempDir_hWnd, gsClientFilesTemp);

        return TRUE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

